package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractURICheckConfigBuilder
    <T extends AbstractURICheckConfigBuilder<T>>
    extends AbstractURIConfigBuilder<T>
    implements URICheckConfig
{
    private long checkInterval;

    protected AbstractURICheckConfigBuilder(final URICheckConfig config) {
        super(config);
        checkInterval(config.checkInterval());
    }

    protected AbstractURICheckConfigBuilder(
        final IniConfig config,
        final URICheckConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        checkInterval =
            CHECK_INTERVAL.extract(config, defaults.checkInterval());
    }

    @Override
    public long checkInterval() {
        return checkInterval;
    }

    public T checkInterval(final long checkInterval) {
        this.checkInterval = checkInterval;
        return self();
    }

    public void copyTo(final AbstractURICheckConfigBuilder<?> other) {
        copyTo((AbstractURIConfigBuilder<?>) other);
        other.checkInterval(checkInterval());
    }
}

