package ru.yandex.http.config;

import java.net.URI;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractURIConfigBuilder
    <T extends AbstractURIConfigBuilder<T>>
    extends AbstractHttpTargetConfigBuilder<T>
    implements URIConfig
{
    private URI uri;

    protected AbstractURIConfigBuilder(final URIConfig config) {
        super(config);
        uri = config.uri();
    }

    protected AbstractURIConfigBuilder(
        final IniConfig config,
        final URIConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        uri = config.getURI("uri", defaults.uri());
    }

    @Override
    public URI uri() {
        return uri;
    }

    public T uri(final URI uri) {
        this.uri = uri;
        return self();
    }

    public void copyTo(final AbstractURIConfigBuilder<?> other) {
        copyTo((AbstractHttpTargetConfigBuilder<?>) other);
        other.uri(uri());
    }
}

