package ru.yandex.http.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface ClientHttpsConfig extends HttpsConfig {
    ParameterConfig<Boolean> VERIFY_CERTIFICATE = new ParameterConfig<>(
        "verify-certificate",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> VERIFY_HOSTNAME = new ParameterConfig<>(
        "verify-hostname",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<String> TRUST_MANAGER_ALGORITHM = new ParameterConfig<>(
        "trust-manager-algorithm",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    boolean verifyCertificate();

    boolean verifyHostname();

    // TrustManager algorithm. "PKIX", "SunX509" etc.
    String trustManagerAlgorithm();
}

