package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ClientHttpsConfigBuilder
    extends AbstractClientHttpsConfigBuilder<ClientHttpsConfigBuilder>
{
    public ClientHttpsConfigBuilder() {
        this(ClientHttpsConfigDefaults.INSTANCE);
    }

    public ClientHttpsConfigBuilder(final ClientHttpsConfig config) {
        super(config);
    }

    public ClientHttpsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, ClientHttpsConfigDefaults.INSTANCE);
    }

    public ClientHttpsConfigBuilder(
        final IniConfig config,
        final ClientHttpsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ClientHttpsConfigBuilder self() {
        return this;
    }

    public ImmutableClientHttpsConfig build() throws ConfigException {
        return new ImmutableClientHttpsConfig(this);
    }
}

