package ru.yandex.http.config;

import javax.net.ssl.TrustManagerFactory;

public class ClientHttpsConfigDefaults
    extends HttpsConfigDefaults
    implements ClientHttpsConfig
{
    public static final ClientHttpsConfigDefaults INSTANCE =
        new ClientHttpsConfigDefaults();

    private static final String DEFAULT_TRUST_MANAGER_ALGORITHM =
        TrustManagerFactory.getDefaultAlgorithm();

    @Override
    public String protocol() {
        return "TLS";
    }

    @Override
    public boolean verifyCertificate() {
        return true;
    }

    @Override
    public boolean verifyHostname() {
        return true;
    }

    @Override
    public String trustManagerAlgorithm() {
        return DEFAULT_TRUST_MANAGER_ALGORITHM;
    }
}

