package ru.yandex.http.config;

import java.util.Map;

import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.PositiveValidator;

public interface DnsConfig {
    ParameterConfig<Long> DNS_TTL = new ParameterConfig<>(
        "dns-ttl",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());

    ParameterConfig<Long> DNS_UPDATE_INTERVAL = new ParameterConfig<>(
        "dns-update-interval",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());

    long dnsTtl();

    long dnsUpdateInterval();

    Map<String, String> dnsHostsMapping();
}

