package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class DnsConfigBuilder
    extends AbstractDnsConfigBuilder<DnsConfigBuilder>
{
    public DnsConfigBuilder() {
        super(DnsConfigDefaults.INSTANCE);
    }

    public DnsConfigBuilder(final DnsConfig config) {
        super(config);
    }

    public DnsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, DnsConfigDefaults.INSTANCE);
    }

    public DnsConfigBuilder(
        final IniConfig config,
        final DnsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public DnsConfigBuilder self() {
        return this;
    }

    public ImmutableDnsConfig build() throws ConfigException {
        return new ImmutableDnsConfig(this);
    }
}

