package ru.yandex.http.config;

import java.util.Collections;
import java.util.Map;

public class DnsConfigDefaults implements DnsConfig {
    public static final DnsConfigDefaults INSTANCE = new DnsConfigDefaults();

    private static final long DNS_TTL = 600000L;
    private static final long DNS_UPDATE_INTERVAL = 60000L;

    protected DnsConfigDefaults() {
    }

    @Override
    public long dnsTtl() {
        return DNS_TTL;
    }

    @Override
    public long dnsUpdateInterval() {
        return DNS_UPDATE_INTERVAL;
    }

    @Override
    public Map<String, String> dnsHostsMapping() {
        return Collections.emptyMap();
    }
}

