package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ExternalDataConfigBuilder
    extends AbstractExternalDataConfigBuilder<ExternalDataConfigBuilder>
{
    public ExternalDataConfigBuilder() {
        super(ExternalDataConfigDefaults.INSTANCE);
    }

    public ExternalDataConfigBuilder(final ExternalDataConfig config) {
        super(config);
    }

    public ExternalDataConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ExternalDataConfigDefaults.INSTANCE);
    }

    public ExternalDataConfigBuilder(
        final IniConfig config,
        final ExternalDataConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ExternalDataConfigBuilder self() {
        return this;
    }

    public ImmutableExternalDataConfig build() throws ConfigException {
        return new ImmutableExternalDataConfig(this);
    }
}

