package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class FilterSearchConfigBuilder
    extends AbstractFilterSearchConfigBuilder<FilterSearchConfigBuilder>
{
    public FilterSearchConfigBuilder() {
        super(FilterSearchConfigDefaults.INSTANCE);
    }

    public FilterSearchConfigBuilder(final FilterSearchConfig config) {
        super(config);
    }

    public FilterSearchConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, FilterSearchConfigDefaults.INSTANCE);
    }

    public FilterSearchConfigBuilder(
        final IniConfig config,
        final FilterSearchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public FilterSearchConfigBuilder self() {
        return this;
    }

    public ImmutableFilterSearchConfig build() throws ConfigException {
        return new ImmutableFilterSearchConfig(this);
    }
}

