package ru.yandex.http.config;

import java.net.URI;
import java.net.URISyntaxException;

public class FilterSearchConfigDefaults
    extends URIConfigDefaults
    implements FilterSearchConfig
{
    public static final FilterSearchConfigDefaults INSTANCE =
        new FilterSearchConfigDefaults();

    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final int DEFAULT_IO_RETRIES_COUNT = 2;
    private static final FilterSearchRetryConfigDefaults DEFAULT_IO_RETRIES =
        new FilterSearchRetryConfigDefaults();
    private static final URI DEFAULT_URI;

    static {
        try {
            DEFAULT_URI =
                new URI("http://api.mail.yandex.net/api/filter_search")
                    .parseServerAuthority();
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected FilterSearchConfigDefaults() {
    }

    @Override
    public int timeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public int connectTimeout() {
        return DEFAULT_CONNECT_TIMEOUT;
    }

    @Override
    public FilterSearchRetryConfigDefaults ioRetries() {
        return DEFAULT_IO_RETRIES;
    }

    @Override
    public URI uri() {
        return DEFAULT_URI;
    }

    @Override
    public int batchSize() {
        return -1;
    }

    public static class FilterSearchRetryConfigDefaults
        extends RetriesConfigDefaults
    {
        protected FilterSearchRetryConfigDefaults() {
        }

        @Override
        public int count() {
            return DEFAULT_IO_RETRIES_COUNT;
        }
    }
}

