package ru.yandex.http.config;

import java.nio.charset.Charset;

public class HttpConnectionConfigDefaults implements HttpConnectionConfig {
    public static final HttpConnectionConfigDefaults INSTANCE =
        new HttpConnectionConfigDefaults();

    private static final int DEFAULT_BUFFER_SIZE = 8192;

    protected HttpConnectionConfigDefaults() {
    }

    @Override
    public int bufferSize() {
        return DEFAULT_BUFFER_SIZE;
    }

    @Override
    public int fragmentSizeHint() {
        return -1;
    }

    @Override
    public Charset headersCharset() {
        return null;
    }

    @Override
    public boolean briefHeaders() {
        return false;
    }
}

