package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HttpHostConfigBuilder
    extends AbstractHttpHostConfigBuilder<HttpHostConfigBuilder>
{
    public HttpHostConfigBuilder() {
        super(HttpHostConfigDefaults.INSTANCE);
    }

    public HttpHostConfigBuilder(final HttpHostConfig config) {
        super(config);
    }

    public HttpHostConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, HttpHostConfigDefaults.INSTANCE);
    }

    public HttpHostConfigBuilder(
        final IniConfig config,
        final HttpHostConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HttpHostConfigBuilder self() {
        return this;
    }

    public ImmutableHttpHostConfig build() throws ConfigException {
        return new ImmutableHttpHostConfig(this);
    }
}

