package ru.yandex.http.config;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import org.apache.http.HttpHost;

import ru.yandex.stater.StatersConfig;

public interface HttpTargetConfig extends HttpConnectionConfig {
    HttpHost proxy();

    Charset requestCharset();

    Charset responseCharset();

    int connections();

    int timeout();

    int connectTimeout();

    int poolTimeout();

    int sessionTimeout();

    RetriesConfig ioRetries();

    RetriesConfig httpRetries();

    boolean keepAlive();

    boolean contentCompression();

    boolean redirects();

    boolean redirectPosts();

    boolean relativeRedirects();

    boolean circularRedirects();

    int maxRedirects();

    boolean passReferer();

    ClientHttpsConfig httpsConfig();

    List<Map.Entry<String, String>> tvm2Headers();

    @Nullable
    StatersConfig statersConfig();
}

