package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HttpTargetConfigBuilder
    extends AbstractHttpTargetConfigBuilder<HttpTargetConfigBuilder>
{
    public HttpTargetConfigBuilder() {
        super(HttpTargetConfigDefaults.INSTANCE);
    }

    public HttpTargetConfigBuilder(final HttpTargetConfig config) {
        super(config);
    }

    public HttpTargetConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, HttpTargetConfigDefaults.INSTANCE);
    }

    public HttpTargetConfigBuilder(
        final IniConfig config,
        final HttpTargetConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HttpTargetConfigBuilder self() {
        return this;
    }

    public ImmutableHttpTargetConfig build() throws ConfigException {
        return new ImmutableHttpTargetConfig(this);
    }
}

