package ru.yandex.http.config;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;

import ru.yandex.stater.StatersConfig;

public class HttpTargetConfigDefaults
    extends HttpConnectionConfigDefaults
    implements HttpTargetConfig
{
    public static final HttpTargetConfigDefaults INSTANCE =
        new HttpTargetConfigDefaults();

    private static final int TIMEOUT = 1000;
    private static final int SESSION_TIMEOUT = -1;

    protected HttpTargetConfigDefaults() {
    }

    @Override
    public HttpHost proxy() {
        return null;
    }

    @Override
    public Charset requestCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public Charset responseCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public int connections() {
        return -1;
    }

    @Override
    public int timeout() {
        return TIMEOUT;
    }

    @Override
    public int connectTimeout() {
        return timeout();
    }

    @Override
    public int poolTimeout() {
        return timeout();
    }

    @Override
    public int sessionTimeout() {
        return SESSION_TIMEOUT;
    }

    @Override
    public RetriesConfigDefaults ioRetries() {
        return RetriesConfigDefaults.INSTANCE;
    }

    @Override
    public RetriesConfigDefaults httpRetries() {
        return RetriesConfigDefaults.INSTANCE;
    }

    @Override
    public boolean keepAlive() {
        return true;
    }

    @Override
    public boolean contentCompression() {
        return true;
    }

    @Override
    public boolean redirects() {
        return false;
    }

    @Override
    public boolean redirectPosts() {
        return true;
    }

    @Override
    public boolean relativeRedirects() {
        return true;
    }

    @Override
    public boolean circularRedirects() {
        return true;
    }

    @Override
    public int maxRedirects() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean passReferer() {
        return true;
    }

    @Override
    public ClientHttpsConfig httpsConfig() {
        return ClientHttpsConfigDefaults.INSTANCE;
    }

    @Override
    public List<Map.Entry<String, String>> tvm2Headers() {
        return Collections.emptyList();
    }

    @Override
    public StatersConfig statersConfig() {
        return null;
    }
}

