package ru.yandex.http.config;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.NullableSectionConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface HttpsConfig {
    ParameterConfig<String> PROTOCOL = new ParameterConfig<>(
        "protocol",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<List<String>> ENABLED_PROTOCOLS = new ParameterConfig<>(
        "enabled-protocols",
        new CollectionParser<>(
            NonEmptyValidator.TRIMMED,
            ArrayList::new),
        GenericFunction.identity());
    ParameterConfig<String> JSSE_PROVIDER = new ParameterConfig<>(
        "jsse-provider",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> SECURE_RANDOM_ALGORITHM = new ParameterConfig<>(
        "secure-random-algorithm",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> SECURE_RANDOM_PROVIDER = new ParameterConfig<>(
        "secure-random-provider",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    NullableSectionConfig<
        KeyStoreConfig,
        ImmutableKeyStoreConfig,
        KeyStoreConfigBuilder>
        KEY_STORE_CONFIG = new NullableSectionConfig<>(
            "keystore",
            KeyStoreConfigBuilder::new,
            ImmutableKeyStoreConfig::new,
            null,
            KeyStoreConfigDefaults.INSTANCE,
            null);

    // Protocol used: TLS, TLSv1.2, SSL etc.
    String protocol();

    // List of enabled protocols
    // Enable all supported protocols except SSL* if empty.
    List<String> enabledProtocols();

    // Encryption algorithms provider, used by TrustManager, KeyManager and
    // SSLContext. "SunJSSE", "IBMJSSE", "BCJSSE" etc.
    String jsseProvider();

    // SecureRandom algorithm. "NativePRNG", "SHA1PRNG", "DRBG" etc.
    String secureRandomAlgorithm();

    // SecureRandom algorithm provider. "BC" etc.
    String secureRandomProvider();

    // Key store config, may be null for clients and mandatory for servers
    KeyStoreConfig keyStoreConfig();
}

