package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HttpsConfigBuilder
    extends AbstractHttpsConfigBuilder<HttpsConfigBuilder>
{
    public HttpsConfigBuilder() {
        this(HttpsConfigDefaults.INSTANCE);
    }

    public HttpsConfigBuilder(final HttpsConfig config) {
        super(config);
    }

    public HttpsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, HttpsConfigDefaults.INSTANCE);
    }

    public HttpsConfigBuilder(
        final IniConfig config,
        final HttpsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HttpsConfigBuilder self() {
        return this;
    }

    public ImmutableHttpsConfig build() throws ConfigException {
        return new ImmutableHttpsConfig(this);
    }
}

