package ru.yandex.http.config;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;

public class HttpsConfigDefaults implements HttpsConfig {
    public static final HttpsConfigDefaults INSTANCE =
        new HttpsConfigDefaults();

    private static final String DEFAULT_SECURE_RANDOM_ALGORITHM =
        new SecureRandom().getAlgorithm();

    protected HttpsConfigDefaults() {
    }

    @Override
    public String protocol() {
        return null;
    }

    @Override
    public List<String> enabledProtocols() {
        return Collections.emptyList();
    }

    @Override
    public String jsseProvider() {
        return null;
    }

    @Override
    public String secureRandomAlgorithm() {
        return DEFAULT_SECURE_RANDOM_ALGORITHM;
    }

    @Override
    public String secureRandomProvider() {
        return null;
    }

    @Override
    public KeyStoreConfig keyStoreConfig() {
        return null;
    }
}

