package ru.yandex.http.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableDnsConfig implements DnsConfig, ImmutableConfig {
    private final long dnsTtl;
    private final long dnsUpdateInterval;
    private final Map<String, String> dnsHostsMapping;

    public ImmutableDnsConfig(final DnsConfig config)
        throws ConfigException
    {
        dnsTtl = DNS_TTL.validate(config.dnsTtl());
        dnsUpdateInterval =
            DNS_UPDATE_INTERVAL.validate(config.dnsUpdateInterval());
        dnsHostsMapping = new HashMap<>(config.dnsHostsMapping());
    }

    @Override
    public long dnsTtl() {
        return dnsTtl;
    }

    @Override
    public long dnsUpdateInterval() {
        return dnsUpdateInterval;
    }

    @Override
    public Map<String, String> dnsHostsMapping() {
        return dnsHostsMapping;
    }
}

