package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableExternalDataConfig
    extends ImmutableURIConfig
    implements ExternalDataConfig
{
    private final long updateInterval;

    public ImmutableExternalDataConfig(final ExternalDataConfig config)
        throws ConfigException
    {
        super(config);
        updateInterval = UPDATE_INTERVAL.validate(config.updateInterval());
    }

    @Override
    public long updateInterval() {
        return updateInterval;
    }
}

