package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableFilterSearchConfig
    extends ImmutableURIConfig
    implements FilterSearchConfig
{
    private final int batchSize;

    public ImmutableFilterSearchConfig(final FilterSearchConfig config)
        throws ConfigException
    {
        super(config);
        batchSize = config.batchSize();
        if (batchSize <= 0) {
            throw new ConfigException("Batch size must be positive");
        }
    }

    @Override
    public int batchSize() {
        return batchSize;
    }
}

