package ru.yandex.http.config;

import java.nio.charset.Charset;

import org.apache.http.config.ConnectionConfig;

import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableHttpConnectionConfig
    implements HttpConnectionConfig, ImmutableConfig
{
    private final int bufferSize;
    private final int fragmentSizeHint;
    private final Charset headersCharset;
    private final boolean briefHeaders;

    public ImmutableHttpConnectionConfig(final HttpConnectionConfig config) {
        bufferSize = config.bufferSize();
        fragmentSizeHint = config.fragmentSizeHint();
        headersCharset = config.headersCharset();
        briefHeaders = config.briefHeaders();
    }

    @Override
    public int bufferSize() {
        return bufferSize;
    }

    @Override
    public int fragmentSizeHint() {
        return fragmentSizeHint;
    }

    @Override
    public Charset headersCharset() {
        return headersCharset;
    }

    @Override
    public boolean briefHeaders() {
        return briefHeaders;
    }

    public ConnectionConfig toConnectionConfig() {
        return ConnectionConfig
            .custom()
            .setBufferSize(bufferSize)
            .setFragmentSizeHint(fragmentSizeHint)
            .setCharset(headersCharset)
            .build();
    }
}

