package ru.yandex.http.config;

import org.apache.http.HttpHost;

import ru.yandex.parser.config.ConfigException;

public class ImmutableHttpHostConfig
    extends ImmutableHttpTargetConfig
    implements HttpHostConfig
{
    private final HttpHost host;

    public ImmutableHttpHostConfig(final HttpHostConfig config)
        throws ConfigException
    {
        super(config);
        host = config.host();

        if (host == null) {
            throw new ConfigException("Host is not set");
        }
    }

    @Override
    public HttpHost host() {
        return host;
    }
}

