package ru.yandex.http.config;

import java.net.URL;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableKeyStoreConfig
    implements ImmutableConfig, KeyStoreConfig
{
    private final URL file;
    private final String type;
    private final String password;

    public ImmutableKeyStoreConfig(final KeyStoreConfig config)
        throws ConfigException
    {
        file = FILE.validate(config.file());
        type = TYPE.validate(config.type());
        password = PASSWORD.validate(config.password());
    }

    @Override
    public URL file() {
        return file;
    }

    @Override
    public String type() {
        return type;
    }

    @Override
    public String password() {
        return password;
    }
}

