package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableRetriesConfig implements RetriesConfig {
    private final int count;
    private final long interval;

    public ImmutableRetriesConfig(final RetriesConfig config)
        throws ConfigException
    {
        count = config.count();
        interval = config.interval();
        if (count < 0) {
            throw new ConfigException("Retry count must be a non-negative");
        }
        if (count > 0 && interval < 0L) {
            throw new ConfigException("Retry interval must be non-negative");
        }
    }

    @Override
    public int count() {
        return count;
    }

    @Override
    public long interval() {
        return interval;
    }
}

