package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableURICheckConfig
    extends ImmutableURIConfig
    implements URICheckConfig
{
    private final long checkInterval;

    public ImmutableURICheckConfig(final URICheckConfig config)
        throws ConfigException
    {
        super(config);
        checkInterval = CHECK_INTERVAL.validate(config.checkInterval());
    }

    @Override
    public long checkInterval() {
        return checkInterval;
    }
}

