package ru.yandex.http.config;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.http.HttpHost;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.string.URIParser;

public class ImmutableURIConfig
    extends ImmutableHttpTargetConfig
    implements URIConfig
{
    private final URI uri;
    private final HttpHost host;
    private final String request;

    public ImmutableURIConfig(final URIConfig config) throws ConfigException {
        super(config);
        uri = adjustUri(config.uri());
        try {
            host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        } catch (RuntimeException e) {
            throw new ConfigException("Failed to extract host", e);
        }
        String path = uri.getRawPath();
        if (path == null) {
            path = "/";
        }
        try {
            request = URIParser.createURI(
                null,
                null,
                null,
                -1,
                path,
                uri.getRawQuery(),
                null,
                null,
                null)
                .toASCIIString();
        } catch (URISyntaxException e) {
            throw new ConfigException("Failed to extract request", e);
        }
    }

    protected URI adjustUri(final URI uri) throws ConfigException {
        if (uri == null) {
            throw new ConfigException("uri wasn't set");
        }
        try {
            return URIParser.stripFragment(uri);
        } catch (URISyntaxException e) {
            throw new ConfigException("Failed to strip URI frament", e);
        }
    }

    @Override
    public URI uri() {
        return uri;
    }

    public HttpHost host() {
        return host;
    }

    public String request() {
        return request;
    }

    public char firstCgiSeparator() {
        if (uri.getRawQuery() == null) {
            return '?';
        } else {
            return '&';
        }
    }
}

