package ru.yandex.http.config;

import java.net.URL;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.InputURLValidator;
import ru.yandex.parser.string.NonEmptyValidator;

public interface KeyStoreConfig {
    ParameterConfig<URL> FILE = new ParameterConfig<>(
        "file",
        x -> FileParser.INSTANCE.apply(x).toURI().toURL(),
        InputURLValidator.INSTANCE);
    ParameterConfig<String> TYPE = new ParameterConfig<>(
        "type",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> PASSWORD = new ParameterConfig<>(
        "password",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    // Server key store
    URL file();

    // Keystore type: JKS, PKCS12 etc.
    String type();

    // Keystore password
    String password();
}

