package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class KeyStoreConfigBuilder
    extends AbstractKeyStoreConfigBuilder<KeyStoreConfigBuilder>
{
    public KeyStoreConfigBuilder() {
        this(KeyStoreConfigDefaults.INSTANCE);
    }

    public KeyStoreConfigBuilder(final KeyStoreConfig config) {
        super(config);
    }

    public KeyStoreConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, KeyStoreConfigDefaults.INSTANCE);
    }

    public KeyStoreConfigBuilder(
        final IniConfig config,
        final KeyStoreConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public KeyStoreConfigBuilder self() {
        return this;
    }

    public ImmutableKeyStoreConfig build() throws ConfigException {
        return new ImmutableKeyStoreConfig(this);
    }
}

