package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonNegativeIntegerValidator;

public class RetriesConfigBuilder implements RetriesConfig {
    private int count;
    private long interval;

    public RetriesConfigBuilder() {
        this(RetriesConfigDefaults.INSTANCE);
    }

    public RetriesConfigBuilder(final RetriesConfig config) {
        count = config.count();
        interval = config.interval();
    }

    public RetriesConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, RetriesConfigDefaults.INSTANCE);
    }

    public RetriesConfigBuilder(
        final IniConfig config,
        final RetriesConfig defaults)
        throws ConfigException
    {
        count = config.get(
            "count",
            defaults.count(),
            NonNegativeIntegerValidator.INSTANCE);
        if (count == 0) {
            interval = 0;
        } else {
            interval = config.getLongDuration(
                "interval",
                defaults.interval());
        }
    }

    @Override
    public int count() {
        return count;
    }

    public RetriesConfigBuilder count(final int count) {
        this.count = count;
        return this;
    }

    @Override
    public long interval() {
        return interval;
    }

    public RetriesConfigBuilder interval(final long interval) {
        this.interval = interval;
        return this;
    }

    public ImmutableRetriesConfig build() throws ConfigException {
        return new ImmutableRetriesConfig(this);
    }
}

