package ru.yandex.http.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;

public interface ServerHttpsConfig extends HttpsConfig {
    ParameterConfig<String> ALIAS_PASSWORD = new ParameterConfig<>(
        "alias-password",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<Integer> HTTP_PORT = new ParameterConfig<>(
        "http-port",
        Integer::valueOf,
        GenericFunction.identity());
    ParameterConfig<String> KEY_MANAGER_ALGORITHM = new ParameterConfig<>(
        "key-manager-algorithm",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    // Keystore alias password
    // If null, then password used. Useful for PKCS12 s, for which alias
    // password always the same as the password (not sure though)
    String aliasPassword();

    // Port to serve HTTP-requests, if < 0, then only HTTPS request allowed
    int httpPort();

    // KeyManager algorithm. "PKIX", "IbmX509" etc.
    String keyManagerAlgorithm();
}

