package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ServerHttpsConfigBuilder
    extends AbstractServerHttpsConfigBuilder<ServerHttpsConfigBuilder>
{
    public ServerHttpsConfigBuilder() {
        this(ServerHttpsConfigDefaults.INSTANCE);
    }

    public ServerHttpsConfigBuilder(final ServerHttpsConfig config) {
        super(config);
    }

    public ServerHttpsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, ServerHttpsConfigDefaults.INSTANCE);
    }

    public ServerHttpsConfigBuilder(
        final IniConfig config,
        final ServerHttpsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ServerHttpsConfigBuilder self() {
        return this;
    }

    public ImmutableServerHttpsConfig build() throws ConfigException {
        return new ImmutableServerHttpsConfig(this);
    }
}

