package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class URICheckConfigBuilder
    extends AbstractURICheckConfigBuilder<URICheckConfigBuilder>
{
    public URICheckConfigBuilder() {
        super(URICheckConfigDefaults.INSTANCE);
    }

    public URICheckConfigBuilder(final URICheckConfig config) {
        super(config);
    }

    public URICheckConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, URICheckConfigDefaults.INSTANCE);
    }

    public URICheckConfigBuilder(
        final IniConfig config,
        final URICheckConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public URICheckConfigBuilder self() {
        return this;
    }

    public ImmutableURICheckConfig build() throws ConfigException {
        return new ImmutableURICheckConfig(this);
    }
}

