package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class URIConfigBuilder
    extends AbstractURIConfigBuilder<URIConfigBuilder>
{
    public URIConfigBuilder() {
        super(URIConfigDefaults.INSTANCE);
    }

    public URIConfigBuilder(final URIConfig config) {
        super(config);
    }

    public URIConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, URIConfigDefaults.INSTANCE);
    }

    public URIConfigBuilder(final IniConfig config, final URIConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public URIConfigBuilder self() {
        return this;
    }

    public ImmutableURIConfig build() throws ConfigException {
        return new ImmutableURIConfig(this);
    }
}

