package ru.yandex.http.util.nio;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;

import ru.yandex.charset.Decoder;
import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.CharsetUtils;

public abstract class AbstractAsyncCharArrayConsumer<T>
    extends AbstractAsyncByteArrayConsumer<T>
{
    @SuppressWarnings("HidingField")
    private ContentType contentType = null;

    protected abstract T buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws Exception;

    @Override
    protected T buildResult(final HttpContext context) throws Exception {
        Decoder decoder = new Decoder(CharsetUtils.decoder(contentType));
        if (buf != null) {
            decoder.process(buf, 0, len);
        }
        return buildResult(decoder, context);
    }

    @Override
    protected void processEntity(final HttpEntity entity)
        throws HttpException
    {
        super.processEntity(entity);
        contentType = CharsetUtils.contentType(entity);
    }
}

