package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.function.StringBuilderProcessorAdapter;
import ru.yandex.http.util.RequestToString;
import ru.yandex.http.util.YandexHeaders;

public abstract class AbstractExceptionMessageAsyncConsumer<T>
    extends AbstractAsyncCharArrayConsumer<T>
{
    private static final String SUFFIX = " failed with ";
    private final StringBuilder sb;

    protected AbstractExceptionMessageAsyncConsumer(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        String responseString = response.toString();
        StringBuilder sb;
        try {
            sb = RequestToString.requestToStringBuilder(
                "Request ",
                producer.generateRequest(),
                SUFFIX.length() + responseString.length(),
                YandexHeaders.DEFAULT_HIDDEN_HEADERS);
        } catch (HttpException | IOException e) {
            sb = new StringBuilder("Request to host ");
            sb.append(producer.getTarget());
        }
        sb.append(SUFFIX);
        sb.append(responseString);
        this.sb = sb;
    }

    protected abstract Exception buildException(final String message);

    @Override
    protected T buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws Exception
    {
        if (len > 0) {
            sb.append(" with body: ");
            data.processWith(new StringBuilderProcessorAdapter(sb));
        }
        throw buildException(new String(sb));
    }
}

