package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class AbstractFilterAsyncResponseConsumer<T> {
    protected HttpAsyncResponseConsumer<? extends T> consumer;

    public AbstractFilterAsyncResponseConsumer(
        final HttpAsyncResponseConsumer<? extends T> consumer)
    {
        this.consumer = consumer;
    }

    public void close() throws IOException {
        consumer.close();
    }

    public boolean cancel() {
        return consumer.cancel();
    }

    public void responseReceived(final HttpResponse response)
        throws HttpException, IOException
    {
        consumer.responseReceived(response);
    }

    public void consumeContent(
        final ContentDecoder decoder,
        final IOControl ioctrl)
        throws IOException
    {
        consumer.consumeContent(decoder, ioctrl);
    }

    public void responseCompleted(final HttpContext context) {
        consumer.responseCompleted(context);
    }

    public void failed(final Exception e) {
        consumer.failed(e);
    }

    public Exception getException() {
        return consumer.getException();
    }

    public boolean isDone() {
        return consumer.isDone();
    }
}

