package ru.yandex.http.util.nio;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.HttpStatusPredicates;

public class AsyncCharArrayProcessableConsumerFactory
    implements HttpAsyncResponseConsumerFactory<CharArrayProcessable>
{
    public static final AsyncCharArrayProcessableConsumerFactory INSTANCE =
        new AsyncCharArrayProcessableConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<
        CharArrayProcessable> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<
        CharArrayProcessable> ANY_GOOD =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<
        CharArrayProcessable> NON_FATAL =
            new StatusCheckAsyncResponseConsumerFactory<>(
                HttpStatusPredicates.NON_FATAL,
                INSTANCE);

    protected AsyncCharArrayProcessableConsumerFactory() {
    }

    @Override
    public AsyncCharArrayProcessableConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        return new AsyncCharArrayProcessableConsumer();
    }
}

