package ru.yandex.http.util.nio;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

public class AsyncStringConsumerFactory
    implements HttpAsyncResponseConsumerFactory<String>
{
    public static final AsyncStringConsumerFactory INSTANCE =
        new AsyncStringConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<String> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<String>
        ANY_GOOD =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<
        String> NON_FATAL =
            new StatusCheckAsyncResponseConsumerFactory<>(
                HttpStatusPredicates.NON_FATAL,
                INSTANCE);

    protected AsyncStringConsumerFactory() {
    }

    @Override
    public AsyncStringConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        return new AsyncStringConsumer();
    }
}

