package ru.yandex.http.util.nio;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.BadResponseException;

public class BadResponseExceptionAsyncConsumer<T>
    extends AbstractAsyncCharArrayConsumer<T>
{
    private final HttpAsyncRequestProducer producer;
    private final HttpResponse response;

    public BadResponseExceptionAsyncConsumer(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        this.producer = producer;
        this.response = response;
    }

    @Override
    protected T buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws Exception
    {
        throw new BadResponseException(
            producer,
            response,
            data.toString());
    }
}

