package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.EntityAsyncContentProducer;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.http.util.HttpHostAppender;
import ru.yandex.http.util.RequestToString;
import ru.yandex.http.util.YandexHeaders;

public class BasicAsyncRequestProducer
    extends AbstractStringBuilderable
    implements HttpAsyncRequestProducer
{
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpAsyncContentProducer producer;

    public BasicAsyncRequestProducer(
        final HttpHost target,
        final HttpRequest request)
    {
        this.target = target;
        this.request = request;
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity =
                ((HttpEntityEnclosingRequest) request).getEntity();
            if (entity == null) {
                producer = null;
            } else if (entity instanceof HttpAsyncContentProducer) {
                producer = (HttpAsyncContentProducer) entity;
            } else {
                producer = new EntityAsyncContentProducer(entity);
            }
        } else {
            producer = null;
        }
    }

    @Override
    public HttpHost getTarget() {
        return target;
    }

    @Override
    public HttpRequest generateRequest() {
        return request;
    }

    @Override
    public void produceContent(
        final ContentEncoder encoder,
        final IOControl ioControl)
        throws IOException
    {
        if (producer != null) {
            producer.produceContent(encoder, ioControl);
            if (encoder.isCompleted()) {
                producer.close();
            }
        }
    }

    @Override
    public void requestCompleted(final HttpContext context) {
    }

    @Override
    public void failed(final Exception e) {
    }

    @Override
    public boolean isRepeatable() {
        return producer == null || producer.isRepeatable();
    }

    @Override
    public void resetRequest() throws IOException {
        if (producer != null) {
            producer.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (producer != null) {
            producer.close();
        }
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        HttpHostAppender.appendTo(sb, target);
        sb.append(' ');
        RequestToString.appendRequest(
            sb,
            request.getRequestLine(),
            request.getAllHeaders(),
            YandexHeaders.DEFAULT_HIDDEN_HEADERS);
        if (producer != null) {
            sb.append(' ');
            sb.append(producer.toString());
        }
    }
}

