package ru.yandex.http.util.nio;

import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpContext;

public class BasicAsyncResponseConsumer
    extends AbstractAsyncByteArrayConsumer<HttpResponse>
{
    private final HttpResponse response;

    public BasicAsyncResponseConsumer(final HttpResponse response) {
        this.response = response;
    }

    @Override
    protected HttpResponse buildResult(final HttpContext context)
        throws Exception
    {
        NByteArrayEntity entity = new NByteArrayEntity(buf, 0, len);
        entity.setContentType(contentTypeHeader);
        entity.setContentEncoding(contentEncodingHeader);
        response.setEntity(entity);
        return response;
    }
}

