package ru.yandex.http.util.nio;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

public enum BasicAsyncResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory<HttpResponse>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<HttpResponse>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<HttpResponse>
        ANY_GOOD = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);

    @Override
    public BasicAsyncResponseConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        return new BasicAsyncResponseConsumer(response);
    }
}

