package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.EntityAsyncContentProducer;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

public class BasicAsyncResponseProducer implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private HttpAsyncContentProducer producer = null;

    public BasicAsyncResponseProducer(final HttpResponse response) {
        this.response = response;
    }

    private void prepareProducer() {
        if (producer == null) {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                producer = EmptyAsyncContentProducer.INSTANCE;
            } else {
                if (entity instanceof HttpAsyncContentProducer) {
                    producer = (HttpAsyncContentProducer) entity;
                } else {
                    producer = new EntityAsyncContentProducer(entity);
                }
            }
        }
    }

    @Override
    public HttpResponse generateResponse() {
        return response;
    }

    @Override
    public void produceContent(
        final ContentEncoder encoder,
        final IOControl ioControl)
        throws IOException
    {
        prepareProducer();
        producer.produceContent(encoder, ioControl);
        if (encoder.isCompleted()) {
            producer.close();
        }
    }

    @Override
    public void responseCompleted(final HttpContext context) {
    }

    @Override
    public void failed(final Exception e) {
    }

    @Override
    public void close() throws IOException {
        prepareProducer();
        producer.close();
    }

    @Override
    public String toString() {
        return response.toString();
    }
}

