package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.http.util.HttpStatusPredicates;

public enum ByteArrayProcessableAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<ByteArrayProcessable>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<
        ByteArrayProcessable>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<
        ByteArrayProcessable>
        ANY_GOOD = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);

    @Override
    public ByteArrayProcessableAsyncConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new ByteArrayProcessableAsyncConsumer();
    }
}
