package ru.yandex.http.util.nio;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.http.util.ByteArrayProcessableWithContentType;
import ru.yandex.http.util.CharsetUtils;

public class ByteArrayProcessableWithContentTypeAsyncConsumer
    extends AbstractAsyncByteArrayConsumer<ByteArrayProcessableWithContentType>
{
    private ContentType contentType = CharsetUtils.DEFAULT_CONTENT_TYPE;

    @Override
    protected void processEntity(final HttpEntity entity)
        throws HttpException
    {
        super.processEntity(entity);
        contentType = CharsetUtils.contentType(entity);
    }

    @Override
    protected ByteArrayProcessableWithContentType buildResult(
        final HttpContext context)
    {
        ByteArrayProcessable data;
        if (buf == null) {
            data = new ByteArrayProcessable();
        } else {
            data = new ByteArrayProcessable(buf, 0, len);
        }
        return new ByteArrayProcessableWithContentType(
            data,
            contentType,
            contentTypeHeader,
            contentEncodingHeader);
    }
}

