package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.ByteArrayProcessableWithContentType;
import ru.yandex.http.util.HttpStatusPredicates;

public enum ByteArrayProcessableWithContentTypeAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory
        <ByteArrayProcessableWithContentType>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<
        ByteArrayProcessableWithContentType>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<
        ByteArrayProcessableWithContentType>
        ANY_GOOD = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);

    @Override
    public ByteArrayProcessableWithContentTypeAsyncConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new ByteArrayProcessableWithContentTypeAsyncConsumer();
    }
}

