package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class CountingAsyncRequestProducer
    extends FilterAsyncRequestProducer
{
    private final ContentEncoderListener listener;
    private ContentEncoder currentEncoder = null;
    private ContentEncoder currentCountingEncoder = null;

    public CountingAsyncRequestProducer(
        final HttpAsyncRequestProducer consumer,
        final ContentEncoderListener listener)
    {
        super(consumer);
        this.listener = listener;
    }

    @Override
    public void produceContent(
        final ContentEncoder encoder,
        final IOControl ioctrl)
        throws IOException
    {
        if (encoder != currentEncoder) {
            currentCountingEncoder =
                CountingContentEncoder.wrap(encoder, listener);
            currentEncoder = encoder;
        }
        super.produceContent(currentCountingEncoder, ioctrl);
    }
}

