package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

public class CountingAsyncResponseConsumer<T>
    extends FilterAsyncResponseConsumer<T>
{
    private final ContentDecoderListener listener;
    private ContentDecoder currentDecoder = null;
    private ContentDecoder currentCountingDecoder = null;

    public CountingAsyncResponseConsumer(
        final HttpAsyncResponseConsumer<? extends T> consumer,
        final ContentDecoderListener listener)
    {
        super(consumer);
        this.listener = listener;
    }

    @Override
    public void consumeContent(
        final ContentDecoder decoder,
        final IOControl ioctrl)
        throws IOException
    {
        if (decoder != currentDecoder) {
            currentCountingDecoder =
                CountingContentDecoder.wrap(decoder, listener);
            currentDecoder = decoder;
        }
        super.consumeContent(currentCountingDecoder, ioctrl);
    }
}

